;coded by UEZ build 2015-09-10
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

AutoItSetOption("GUIOnEventMode", 1)

_GDIPlus_Startup()

Global Const $sTitle = "GDI+ Wormhole v1 / FPS: ", $iW = 1000, $iH = 800, $iW2 = $iW / 2, $iH2 = $iH / 2
Global Const $hGUI = GUICreate($sTitle & "0", $iW, $iH), $f2Pi = 2 * ATan(-1)
GUISetState()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hGraphic = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetPixelOffsetMode($hGraphic, 4)


;r = radius, $j = amount of circles on the z depth, $iStep = space between dot per circle
Global $c, $t = 0, $p, $q, $z, $i, $r = $iW / 32, $j = 32, $iStep = 8, $aX0[$j], $aY0[$j], $iFPS = 0

GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")

AdlibRegister("FPS", 1000)

Do
	_GDIPlus_GraphicsClear($hGraphic)
	$q = BitAND($t, $j - 1)
	$aX0[$q] = Cos(3 * $t * $f2Pi / 80) * 32 + 1
	$aY0[$q] = Sin(5 * $t * $f2Pi / 80) * 32 + 1
	$z = 16
	For $i = $t To $t - $j + 1 Step - 1
		If $i > 0 Then
			$p = BitAND($i, $j - 1)
			$c = 0x118 - 1.5 * $z
			$c = $c < 0x30 ? 0x30 : $c
			DrawCircle($aX0[$p], $aY0[$p], $z, $r, $iW2, $iH2, 250, 0xF0000000 + $c * 0x10000 + $c * 0x100 + $c)
			$z += 8
		EndIf
	Next
	$t += 1
	_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY)
	$iFPS += 1
Until Not Sleep(10)

Func _Exit()
	AdlibUnRegister("FPS")
	_GDIPlus_GraphicsDispose($hGraphic)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_DeleteObject($hDC_backbuffer)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc

Func FPS()
	WinSetTitle($hGUI, "", $sTitle & $iFPS & " / " & Int($j * (256 / $iStep)) & " px")
	$iFPS = 0
EndFunc

Func DrawCircle($iX, $iY, $iZ, $iR, $iPosX, $iPosY, $d = 250, $iColor = 0xFFF0F0F0) ;d = wormhole distance to the camera on z axis
	Local $t, $x, $y
	Local Const $fXC = $d * $iX / $iZ
	Local Const $fYC = $d * $iY / $iZ
	Local Const $fRC = $d * $iR / $iZ
	Local Static $i = -1024
	Local Const $hBrush = _GDIPlus_BrushCreateSolid($iColor)
	For $t = $i To 255 + $i Step $iStep
		$x = $iPosX + $fXC + $fRC * Cos($t * $f2Pi / 64)
		$y = $iPosY + $fYC + $fRC * Sin($t * $f2Pi / 64)
;~ 		If $x > -1 And $x < $iW + 1 And $y > -1 And $y < $iH + 1 Then
			DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", _
					"handle", $hGraphic, "handle", $hBrush, "float", $x, "float", $y, "float", 2, "float", 2)
;~ 		EndIf
	Next
	_GDIPlus_BrushDispose($hBrush)
	$i += 0.0125 ;i = rotation speed
EndFunc